import busio
import board
import digitalio
from adafruit_stmpe610 import Adafruit_STMPE610_SPI

try:
    spi_bus = board.SPI()
    # initialized spi bus
except ValueError as err:
    print( "Error: spi bus fail: {:}".format(err) )

chip_select = digitalio.DigitalInOut(board.D6)
screen_touch = Adafruit_STMPE610_SPI(spi_bus, chip_select)

print("Ready: Touch the Screen")
while True:
    if not screen_touch.buffer_empty:
        touch_data = screen_touch.read_data()
        print( "X: %d, Y: %d, press: %d" % ( touch_data[1], touch_data[0], touch_data[2] ) )
# 12 bit screen position sampling: 0-4096
# In STELLA instrument orientation:
# X codes right (low) to left (high)
# Y codes bottom (low) to top (high)
# press sense range, 8 bits:
# 255 (very lightest touch) to 0 (three fingers hard press), valid anywhere on the screen.
# typical press seems to be < 50

